/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.findme.network;

import com.buuz135.findme.FindMeMod;
import com.buuz135.findme.IInventoryPuller;
import com.buuz135.findme.network.PositionRequestMessage;
import com.buuz135.findme.tracking.TrackingList;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class PullItemRequestMessage {
    private class_1799 stack;
    private int amount;

    public PullItemRequestMessage(class_1799 stack, int amount) {
        this.stack = stack;
        this.amount = amount;
        TrackingList.trackItem(stack);
    }

    public PullItemRequestMessage() {
    }

    public static boolean compareItems(class_1799 first, class_1799 second) {
        if (FindMeMod.CONFIG.COMMON.IGNORE_ITEM_DAMAGE) {
            return class_1799.method_7984((class_1799)first, (class_1799)second);
        }
        return class_1799.method_31577((class_1799)first, (class_1799)second);
    }

    public PullItemRequestMessage fromBytes(ByteBuf buf) {
        class_2540 packetBuffer = new class_2540(buf);
        this.stack = class_1799.field_8037;
        this.stack = packetBuffer.method_10819();
        this.amount = packetBuffer.readInt();
        return this;
    }

    public void toBytes(ByteBuf buf) {
        class_2540 packetBuffer = new class_2540(buf);
        packetBuffer.method_10793(this.stack);
        packetBuffer.writeInt(this.amount);
    }

    public void handle(Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            class_238 box = new class_238(((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().method_24515()).method_1014((double)FindMeMod.CONFIG.COMMON.RADIUS_RANGE);
            int currentAmount = 0;
            for (class_2338 blockPos : PositionRequestMessage.getBlockPosInAABB(box)) {
                class_2586 tileEntity = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().method_37908().method_8321(blockPos);
                if (tileEntity != null) {
                    for (IInventoryPuller blockExtractor : FindMeMod.BLOCK_EXTRACTORS) {
                        if ((currentAmount += blockExtractor.pull(tileEntity, this.stack, this.amount - currentAmount, ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer())) >= this.amount) break;
                    }
                }
                if (currentAmount < this.amount) continue;
                break;
            }
            if (currentAmount < this.amount) {
                class_1657 player = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
                class_1937 level = player.method_37908();
                level.method_43128(null, player.method_23317(), player.method_23318() + 0.5, player.method_23321(), class_3417.field_15102, class_3419.field_15248, 0.5f, ((level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.7f + 1.0f) * 2.0f);
            }
        });
    }
}

