/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.WeakHashMap;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.ImplementedContainer;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.waystones.api.IMutableWaystone;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.WaystoneOrigin;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.block.WarpPlateBlock;
import net.blay09.mods.waystones.block.entity.ModBlockEntities;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.core.WaystoneTypes;
import net.blay09.mods.waystones.menu.WarpPlateContainer;
import net.blay09.mods.waystones.recipe.ModRecipes;
import net.blay09.mods.waystones.recipe.WarpPlateRecipe;
import net.blay09.mods.waystones.tag.ModItemTags;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerationMode;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerator;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarpPlateBlockEntity
extends WaystoneBlockEntityBase
implements ImplementedContainer {
    private static final Logger logger = LoggerFactory.getLogger(WarpPlateBlockEntity.class);
    private final WeakHashMap<class_1297, Integer> ticksPassedPerEntity = new WeakHashMap();
    private final Random random = new Random();
    private final class_3913 dataAccess;
    private final class_2371<class_1799> items = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
    private int attunementTicks;
    private boolean readyForAttunement;
    private boolean completedFirstAttunement;
    private int lastAttunementSlot;

    public WarpPlateBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModBlockEntities.warpPlate.get(), blockPos, blockState);
        this.dataAccess = new class_3913(){

            public int method_17390(int i) {
                return WarpPlateBlockEntity.this.attunementTicks;
            }

            public void method_17391(int i, int j) {
                WarpPlateBlockEntity.this.attunementTicks = j;
            }

            public int method_17389() {
                return 1;
            }
        };
    }

    public class_2371<class_1799> getItems() {
        return this.items;
    }

    public class_1799 method_5434(int slot, int count) {
        if (!this.completedFirstAttunement) {
            return class_1799.field_8037;
        }
        return super.method_5434(slot, count);
    }

    public class_1799 method_5441(int slot) {
        if (!this.completedFirstAttunement) {
            return class_1799.field_8037;
        }
        return super.method_5441(slot);
    }

    @Override
    public void initializeFromExisting(class_5425 world, Waystone existingWaystone, class_1799 itemStack) {
        super.initializeFromExisting(world, existingWaystone, itemStack);
        class_2487 tag = itemStack.method_7969();
        boolean bl = this.completedFirstAttunement = tag != null && tag.method_10577("CompletedFirstAttunement");
        if (!this.completedFirstAttunement) {
            this.initializeInventory(world);
        }
    }

    @Override
    public void initializeWaystone(class_5425 world, @Nullable class_1309 player, WaystoneOrigin origin) {
        super.initializeWaystone(world, player, origin);
        IWaystone waystone = this.getWaystone();
        if (waystone instanceof IMutableWaystone) {
            String name = NameGenerator.get(world.method_8503()).getName(waystone, world.method_8409(), NameGenerationMode.RANDOM_ONLY);
            ((IMutableWaystone)((Object)waystone)).setName(name);
        }
        WaystoneSyncManager.sendWaystoneUpdateToAll(world.method_8503(), waystone);
        this.initializeInventory(world);
    }

    private void initializeInventory(class_5425 levelAccessor) {
        WarpPlateRecipe initializingRecipe = levelAccessor.method_8410().method_8433().method_30027(ModRecipes.warpPlateRecipeType).stream().filter(recipe -> recipe.method_8114().method_12836().equals("waystones") && recipe.method_8114().method_12832().equals("attuned_shard")).findFirst().orElse(null);
        if (initializingRecipe == null) {
            logger.error("Failed to find Warp Plate recipe for initial attunement");
            this.completedFirstAttunement = true;
            return;
        }
        for (int i = 0; i < 5; ++i) {
            class_1856 ingredient = (class_1856)initializingRecipe.method_8117().get(i);
            class_1799[] ingredientItems = ingredient.method_8105();
            class_1799 ingredientItem = ingredientItems.length > 0 ? ingredientItems[0] : class_1799.field_8037;
            this.method_5447(i, ingredientItem.method_7972());
        }
    }

    @Override
    protected class_2960 getWaystoneType() {
        return WaystoneTypes.WARP_PLATE;
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_1262.method_5426((class_2487)tag, this.items);
        tag.method_10556("ReadyForAttunement", this.readyForAttunement);
        tag.method_10556("CompletedFirstAttunement", this.completedFirstAttunement);
        tag.method_10569("LastAttunementSlot", this.lastAttunementSlot);
    }

    @Override
    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        class_1262.method_5429((class_2487)compound, this.items);
        this.readyForAttunement = compound.method_10577("ReadyForAttunement");
        this.completedFirstAttunement = compound.method_10577("CompletedFirstAttunement");
        this.lastAttunementSlot = compound.method_10550("LastAttunementSlot");
    }

    public BalmMenuProvider getMenuProvider() {
        return new BalmMenuProvider(){

            public class_2561 method_5476() {
                return class_2561.method_43471((String)"container.waystones.warp_plate");
            }

            public class_1703 createMenu(int i, class_1661 playerInventory, class_1657 player) {
                return new WarpPlateContainer(i, WarpPlateBlockEntity.this, WarpPlateBlockEntity.this.dataAccess, playerInventory);
            }

            public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                buf.method_10807(WarpPlateBlockEntity.this.field_11867);
            }
        };
    }

    @Override
    public class_3908 getSettingsMenuProvider() {
        return null;
    }

    public void onEntityCollision(class_1297 entity) {
        Integer ticksPassed = this.ticksPassedPerEntity.putIfAbsent(entity, 0);
        if (ticksPassed == null || ticksPassed != -1) {
            WarpPlateBlock.WarpPlateStatus status = this.getTargetWaystone().filter(IWaystone::isValid).map(it -> WarpPlateBlock.WarpPlateStatus.ACTIVE).orElse(WarpPlateBlock.WarpPlateStatus.INVALID);
            this.field_11863.method_8652(this.field_11867, (class_2680)((class_2680)this.method_11010().method_11657((class_2769)WarpPlateBlock.ACTIVE, (Comparable)Boolean.valueOf(true))).method_11657(WarpPlateBlock.STATUS, (Comparable)((Object)status)), 3);
        }
    }

    private boolean isEntityOnWarpPlate(class_1297 entity) {
        return entity.method_23317() >= (double)this.field_11867.method_10263() && entity.method_23317() < (double)(this.field_11867.method_10263() + 1) && entity.method_23318() >= (double)this.field_11867.method_10264() && entity.method_23318() < (double)(this.field_11867.method_10264() + 1) && entity.method_23321() >= (double)this.field_11867.method_10260() && entity.method_23321() < (double)(this.field_11867.method_10260() + 1);
    }

    public void serverTick() {
        class_238 boundsAbove;
        List entities;
        WarpPlateRecipe recipe = this.trySelectRecipe();
        if (recipe != null) {
            ++this.attunementTicks;
            if (this.attunementTicks >= this.getMaxAttunementTicks()) {
                this.attunementTicks = 0;
                class_1799 attunedShard = recipe.method_8116((class_1263)this, (class_5455)class_5455.field_40585);
                WaystonesAPI.setBoundWaystone(attunedShard, this.getWaystone());
                class_1799 centerStack = this.method_5438(0);
                if (centerStack.method_7947() > 1) {
                    centerStack = centerStack.method_46651(centerStack.method_7947() - 1);
                    if (!class_310.method_1551().field_1724.method_31548().method_7394(centerStack)) {
                        class_310.method_1551().field_1724.method_7328(centerStack, false);
                    }
                }
                this.method_5447(0, attunedShard);
                for (int i = 1; i <= 4; ++i) {
                    this.method_5438(i).method_7934(1);
                }
                this.completedFirstAttunement = true;
            }
        } else {
            this.attunementTicks = 0;
        }
        if (this.method_11010().method_11654(WarpPlateBlock.STATUS) != WarpPlateBlock.WarpPlateStatus.IDLE && (entities = this.field_11863.method_8333((class_1297)null, boundsAbove = new class_238((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (double)(this.field_11867.method_10263() + 1), (double)(this.field_11867.method_10264() + 1), (double)(this.field_11867.method_10260() + 1)), class_1301.field_6154)).isEmpty()) {
            this.field_11863.method_8652(this.field_11867, (class_2680)((class_2680)this.method_11010().method_11657((class_2769)WarpPlateBlock.ACTIVE, (Comparable)Boolean.valueOf(false))).method_11657(WarpPlateBlock.STATUS, (Comparable)((Object)WarpPlateBlock.WarpPlateStatus.IDLE)), 3);
            this.ticksPassedPerEntity.clear();
        }
        int useTime = this.getWarpPlateUseTime();
        Iterator<Map.Entry<class_1297, Integer>> iterator = this.ticksPassedPerEntity.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<class_1297, Integer> entry = iterator.next();
            class_1297 entity = entry.getKey();
            Integer ticksPassed = entry.getValue();
            if (!entity.method_5805() || !this.isEntityOnWarpPlate(entity)) {
                iterator.remove();
                continue;
            }
            if (ticksPassed > useTime) {
                class_1799 targetAttunementStack = this.getTargetAttunementStack();
                IWaystone targetWaystone = WaystonesAPI.getBoundWaystone(targetAttunementStack).orElse(null);
                if (targetWaystone != null && targetWaystone.isValid()) {
                    this.teleportToWarpPlate(entity, targetWaystone, targetAttunementStack);
                }
                if (entity instanceof class_1657) {
                    if (targetWaystone == null) {
                        chatComponent = class_2561.method_43471((String)"chat.waystones.warp_plate_has_no_target");
                        chatComponent.method_27692(class_124.field_1079);
                        ((class_1657)entity).method_7353((class_2561)chatComponent, true);
                    } else if (!targetWaystone.isValid()) {
                        chatComponent = class_2561.method_43471((String)"chat.waystones.warp_plate_has_invalid_target");
                        chatComponent.method_27692(class_124.field_1079);
                        ((class_1657)entity).method_7353((class_2561)chatComponent, true);
                    }
                }
                iterator.remove();
                continue;
            }
            if (ticksPassed == -1) continue;
            entry.setValue(ticksPassed + 1);
        }
    }

    private int getWarpPlateUseTime() {
        float useTimeMultiplier = 1.0f;
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (itemStack.method_7909() == class_1802.field_27063) {
                useTimeMultiplier -= 0.016f * (float)itemStack.method_7947();
                continue;
            }
            if (itemStack.method_7909() != class_1802.field_8777) continue;
            useTimeMultiplier += 0.016f * (float)itemStack.method_7947();
        }
        int configuredUseTime = WaystonesConfig.getActive().cooldowns.warpPlateUseTime;
        return class_3532.method_15340((int)((int)((float)configuredUseTime * useTimeMultiplier)), (int)1, (int)(configuredUseTime * 2));
    }

    private void teleportToWarpPlate(class_1297 entity, IWaystone targetWaystone, class_1799 targetAttunementStack) {
        WaystonesAPI.createDefaultTeleportContext(entity, targetWaystone, WarpMode.WARP_PLATE, this.getWaystone()).flatMap(ctx -> {
            ctx.setWarpItem(targetAttunementStack);
            ctx.setConsumesWarpItem(targetAttunementStack.method_31573(ModItemTags.SINGLE_USE_WARP_SHARDS));
            return PlayerWaystoneManager.tryTeleport(ctx);
        }).ifRight(PlayerWaystoneManager.informRejectedTeleport(entity)).ifLeft(entities -> entities.forEach(this::applyWarpPlateEffects)).left();
    }

    private void applyWarpPlateEffects(class_1297 entity) {
        int fireSeconds = 0;
        int poisonSeconds = 0;
        int blindSeconds = 0;
        int featherFallSeconds = 0;
        int fireResistanceSeconds = 0;
        int witherSeconds = 0;
        int potency = 1;
        ArrayList<class_1799> curativeItems = new ArrayList<class_1799>();
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (itemStack.method_7909() == class_1802.field_8183) {
                fireSeconds += itemStack.method_7947();
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8635) {
                poisonSeconds += itemStack.method_7947();
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8794) {
                blindSeconds += itemStack.method_7947();
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8103 || itemStack.method_7909() == class_1802.field_21086) {
                curativeItems.add(itemStack);
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8477) {
                potency = Math.min(4, potency + itemStack.method_7947());
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8153) {
                featherFallSeconds = Math.min(8, featherFallSeconds + itemStack.method_7947());
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8135) {
                fireResistanceSeconds = Math.min(8, fireResistanceSeconds + itemStack.method_7947());
                continue;
            }
            if (itemStack.method_7909() != class_1802.field_17515) continue;
            witherSeconds += itemStack.method_7947();
        }
        if (entity instanceof class_1309) {
            if (fireSeconds > 0) {
                entity.method_5639(fireSeconds);
            }
            if (poisonSeconds > 0) {
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5899, poisonSeconds * 20, potency));
            }
            if (blindSeconds > 0) {
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5919, blindSeconds * 20, potency));
            }
            if (featherFallSeconds > 0) {
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5906, featherFallSeconds * 20, potency));
            }
            if (fireResistanceSeconds > 0) {
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5918, fireResistanceSeconds * 20, potency));
            }
            if (witherSeconds > 0) {
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5920, witherSeconds * 20, potency));
            }
            for (class_1799 curativeItem : curativeItems) {
                Balm.getHooks().curePotionEffects((class_1309)entity, curativeItem);
            }
        }
    }

    @Nullable
    private WarpPlateRecipe trySelectRecipe() {
        if (!this.readyForAttunement || this.field_11863 == null) {
            return null;
        }
        if (this.method_5438(0).method_7947() > 1) {
            return null;
        }
        return this.field_11863.method_8433().method_8132(ModRecipes.warpPlateRecipeType, (class_1263)this, this.field_11863).orElse(null);
    }

    public class_1799 getTargetAttunementStack() {
        boolean shouldRoundRobin = false;
        boolean shouldPrioritizeSingleUseShards = false;
        ArrayList<class_1799> attunedShards = new ArrayList<class_1799>();
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (itemStack.method_31573(ModItemTags.WARP_SHARDS)) {
                IWaystone waystoneAttunedTo = WaystonesAPI.getBoundWaystone(itemStack).orElse(null);
                if (waystoneAttunedTo == null || waystoneAttunedTo.getWaystoneUid().equals(this.getWaystone().getWaystoneUid())) continue;
                attunedShards.add(itemStack);
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8155) {
                shouldRoundRobin = true;
                continue;
            }
            if (itemStack.method_7909() != class_1802.field_8680) continue;
            shouldPrioritizeSingleUseShards = true;
        }
        if (shouldPrioritizeSingleUseShards && attunedShards.stream().anyMatch(stack -> stack.method_31573(ModItemTags.SINGLE_USE_WARP_SHARDS))) {
            attunedShards.removeIf(stack -> !stack.method_31573(ModItemTags.SINGLE_USE_WARP_SHARDS));
        }
        if (!attunedShards.isEmpty()) {
            this.lastAttunementSlot = (this.lastAttunementSlot + 1) % attunedShards.size();
            return shouldRoundRobin ? (class_1799)attunedShards.get(this.lastAttunementSlot) : (class_1799)attunedShards.get(this.random.nextInt(attunedShards.size()));
        }
        return class_1799.field_8037;
    }

    public Optional<IWaystone> getTargetWaystone() {
        return WaystonesAPI.getBoundWaystone(this.getTargetAttunementStack());
    }

    public int getMaxAttunementTicks() {
        return 30;
    }

    public void markReadyForAttunement() {
        this.readyForAttunement = true;
    }

    public void markEntityForCooldown(class_1297 entity) {
        this.ticksPassedPerEntity.put(entity, -1);
    }

    public boolean isCompletedFirstAttunement() {
        return this.completedFirstAttunement;
    }

    public class_3913 getContainerData() {
        return this.dataAccess;
    }

    public boolean method_5437(int index, class_1799 stack) {
        if (index == 0 && !this.method_5438(0).method_7960()) {
            return false;
        }
        return super.method_5437(index, stack);
    }
}

