/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.recipe;

import com.google.gson.JsonObject;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.resources.recipe.fabric.TemplateRecipeManagerImpl;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.recipe.ShapedRecipeTemplate;
import net.mehvahdjukaar.moonlight.core.recipe.ShapelessRecipeTemplate;
import net.mehvahdjukaar.moonlight.core.recipe.StoneCutterRecipeTemplate;
import net.minecraft.class_1865;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class TemplateRecipeManager {
    private static final Map<class_2960, Function<JsonObject, ? extends IRecipeTemplate<?>>> DESERIALIZERS = new HashMap();

    public static <T extends IRecipeTemplate<?>> void registerTemplate(class_1865<?> serializer, Function<JsonObject, T> deserializer) {
        TemplateRecipeManager.registerTemplate(Utils.getID(serializer), deserializer);
    }

    public static <T extends IRecipeTemplate<?>> void registerTemplate(class_2960 serializerId, Function<JsonObject, T> deserializer) {
        DESERIALIZERS.put(serializerId, deserializer);
    }

    public static IRecipeTemplate<?> read(JsonObject recipe) throws UnsupportedOperationException {
        String type = class_3518.method_15265((JsonObject)recipe, (String)"type");
        Function<JsonObject, IRecipeTemplate<?>> templateFactory = DESERIALIZERS.get(new class_2960(type));
        if (templateFactory != null) {
            ShapedRecipeTemplate st;
            ShapelessRecipeTemplate template = templateFactory.apply(recipe);
            if (template instanceof ShapedRecipeTemplate && (st = (ShapedRecipeTemplate)((Object)template)).shouldBeShapeless()) {
                template = st.toShapeless();
            }
            TemplateRecipeManager.addRecipeConditions(recipe, template);
            return template;
        }
        throw new UnsupportedOperationException(String.format("Invalid recipe serializer: %s. Supported deserializers: %s", type, DESERIALIZERS.keySet()));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void addRecipeConditions(JsonObject recipe, IRecipeTemplate<?> template) {
        void var1_1;
        TemplateRecipeManagerImpl.addRecipeConditions(recipe, var1_1);
    }

    private static IRecipeTemplate<?> forgeConditional(JsonObject recipe) {
        JsonObject object = class_3518.method_15261((JsonObject)recipe, (String)"recipes").get(0).getAsJsonObject();
        IRecipeTemplate<?> template = TemplateRecipeManager.read(object.getAsJsonObject("recipe"));
        TemplateRecipeManager.addRecipeConditions(object, template);
        return template;
    }

    static {
        TemplateRecipeManager.registerTemplate(class_1865.field_9035, ShapedRecipeTemplate::new);
        TemplateRecipeManager.registerTemplate(class_1865.field_9031, ShapelessRecipeTemplate::new);
        TemplateRecipeManager.registerTemplate(class_1865.field_17640, StoneCutterRecipeTemplate::new);
        TemplateRecipeManager.registerTemplate(new class_2960("forge:conditional"), TemplateRecipeManager::forgeConditional);
    }
}

