/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.core.recipe.ShapelessRecipeTemplate;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2447;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7710;
import net.minecraft.class_7923;

public class ShapedRecipeTemplate
implements IRecipeTemplate<class_2447.class_2448> {
    private final List<Object> conditions = new ArrayList<Object>();
    public final class_1792 result;
    public final int count;
    public final String group;
    public final List<String> pattern;
    public final Map<Character, class_1856> keys;
    public final class_7710 category;

    public ShapedRecipeTemplate(JsonObject json) {
        JsonObject result = json.getAsJsonObject("result");
        class_2960 item = new class_2960(result.get("item").getAsString());
        int count = 1;
        JsonElement c = result.get("count");
        if (c != null) {
            count = c.getAsInt();
        }
        this.result = (class_1792)class_7923.field_41178.method_10223(item);
        this.count = count;
        this.category = (class_7710)class_7710.field_40252.method_47920(class_3518.method_15253((JsonObject)json, (String)"category", null), (Enum)class_7710.field_40251);
        JsonElement g = json.get("group");
        this.group = g == null ? "" : g.getAsString();
        ArrayList<String> patternList = new ArrayList<String>();
        JsonArray patterns = json.getAsJsonArray("pattern");
        patterns.forEach(p -> patternList.add(p.getAsString()));
        HashMap<Character, class_1856> keyMap = new HashMap<Character, class_1856>();
        JsonObject keys = json.getAsJsonObject("key");
        keys.entrySet().forEach(e -> keyMap.put(Character.valueOf(((String)e.getKey()).charAt(0)), class_1856.method_52177((JsonElement)((JsonElement)e.getValue()))));
        this.keys = keyMap;
        this.pattern = patternList;
    }

    @Override
    public <T extends BlockType> class_2447.class_2448 createSimilar(T originalMat, T destinationMat, class_1792 unlockItem, String id) {
        class_1792 newRes = BlockType.changeItemType(this.result, originalMat, destinationMat);
        if (newRes == null) {
            throw new UnsupportedOperationException(String.format("Could not convert output item %s from type %s to %s", this.result, originalMat, destinationMat));
        }
        class_2447 builder = new class_2447(this.determineBookCategory(this.category), (class_1935)newRes, this.count);
        boolean atLeastOneChanged = false;
        for (Map.Entry<Character, class_1856> e : this.keys.entrySet()) {
            class_1856 ing = e.getValue();
            class_1856 newIng = IRecipeTemplate.convertIngredients(originalMat, destinationMat, ing);
            if (newIng != null) {
                atLeastOneChanged = true;
            } else {
                newIng = ing;
            }
            builder.method_10428(e.getKey(), newIng);
        }
        if (!atLeastOneChanged) {
            return null;
        }
        this.pattern.forEach(arg_0 -> ((class_2447)builder).method_10439(arg_0));
        builder.method_10435(this.group);
        builder.method_10429("has_planks", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{unlockItem}));
        AtomicReference newRecipe = new AtomicReference();
        if (id == null) {
            builder.method_10431(r -> newRecipe.set((class_2447.class_2448)r));
        } else {
            builder.method_36443(r -> newRecipe.set((class_2447.class_2448)r), id);
        }
        return (class_2447.class_2448)newRecipe.get();
    }

    @Override
    public List<Object> getConditions() {
        return this.conditions;
    }

    @Override
    public void addCondition(Object condition) {
        this.conditions.add(condition);
    }

    public boolean shouldBeShapeless() {
        return this.pattern.size() == 1 && this.pattern.get(0).length() == 1;
    }

    public ShapelessRecipeTemplate toShapeless() {
        return new ShapelessRecipeTemplate(this);
    }
}

