/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerebagatelle.fabricskyboxes.skyboxes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.serialization.Lifecycle;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.AbstractSkybox;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.MonoColorSkybox;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.textured.SquareTexturedSkybox;
import io.github.amerebagatelle.fabricskyboxes.util.JsonObjectWrapper;
import io.github.amerebagatelle.fabricskyboxes.util.object.Blend;
import io.github.amerebagatelle.fabricskyboxes.util.object.Blender;
import io.github.amerebagatelle.fabricskyboxes.util.object.Decorations;
import io.github.amerebagatelle.fabricskyboxes.util.object.Fade;
import io.github.amerebagatelle.fabricskyboxes.util.object.MinMaxEntry;
import io.github.amerebagatelle.fabricskyboxes.util.object.Properties;
import io.github.amerebagatelle.fabricskyboxes.util.object.RGBA;
import io.github.amerebagatelle.fabricskyboxes.util.object.Rotation;
import io.github.amerebagatelle.fabricskyboxes.util.object.Texture;
import io.github.amerebagatelle.fabricskyboxes.util.object.Textures;
import io.github.amerebagatelle.fabricskyboxes.util.object.Weather;
import java.util.List;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import org.joml.Vector3f;
import org.joml.Vector3i;

public class LegacyDeserializer<T extends AbstractSkybox> {
    public static final class_2378<LegacyDeserializer<? extends AbstractSkybox>> REGISTRY = FabricRegistryBuilder.from((class_2385)new class_2370(class_5321.method_29180((class_2960)new class_2960("fabricskyboxes", "legacy_skybox_deserializer")), Lifecycle.stable())).buildAndRegister();
    public static final LegacyDeserializer<MonoColorSkybox> MONO_COLOR_SKYBOX_DESERIALIZER = LegacyDeserializer.register(new LegacyDeserializer<MonoColorSkybox>(LegacyDeserializer::decodeMonoColor, MonoColorSkybox.class), "mono_color_skybox_legacy_deserializer");
    public static final LegacyDeserializer<SquareTexturedSkybox> SQUARE_TEXTURED_SKYBOX_DESERIALIZER = LegacyDeserializer.register(new LegacyDeserializer<SquareTexturedSkybox>(LegacyDeserializer::decodeSquareTextured, SquareTexturedSkybox.class), "square_textured_skybox_legacy_deserializer");
    private final BiConsumer<JsonObjectWrapper, AbstractSkybox> deserializer;

    private LegacyDeserializer(BiConsumer<JsonObjectWrapper, AbstractSkybox> deserializer, Class<T> clazz) {
        this.deserializer = deserializer;
    }

    private static void decodeSquareTextured(JsonObjectWrapper wrapper, AbstractSkybox skybox) {
        LegacyDeserializer.decodeSharedData(wrapper, skybox);
        ((SquareTexturedSkybox)skybox).rotation = new Rotation(true, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(wrapper.getOptionalArrayFloat("axis", 0, 0.0f), wrapper.getOptionalArrayFloat("axis", 1, 0.0f), wrapper.getOptionalArrayFloat("axis", 2, 0.0f)), new Vector3i(0, 0, 0), 0.0f, 1.0f, 0.0f);
        ((SquareTexturedSkybox)skybox).blend = new Blend(wrapper.getOptionalBoolean("shouldBlend", false) ? "add" : "", Blender.DEFAULT);
        ((SquareTexturedSkybox)skybox).textures = new Textures(new Texture(wrapper.getJsonStringAsId("texture_north")), new Texture(wrapper.getJsonStringAsId("texture_south")), new Texture(wrapper.getJsonStringAsId("texture_east")), new Texture(wrapper.getJsonStringAsId("texture_west")), new Texture(wrapper.getJsonStringAsId("texture_top")), new Texture(wrapper.getJsonStringAsId("texture_bottom")));
    }

    private static void decodeMonoColor(JsonObjectWrapper wrapper, AbstractSkybox skybox) {
        LegacyDeserializer.decodeSharedData(wrapper, skybox);
        ((MonoColorSkybox)skybox).color = new RGBA(wrapper.get("red").getAsFloat(), wrapper.get("green").getAsFloat(), wrapper.get("blue").getAsFloat());
    }

    private static void decodeSharedData(JsonObjectWrapper wrapper, AbstractSkybox skybox) {
        float maxAlpha = wrapper.getOptionalFloat("maxAlpha", 1.0f);
        skybox.properties = new Properties.Builder().fade(new Fade(wrapper.get("startFadeIn").getAsInt(), wrapper.get("endFadeIn").getAsInt(), wrapper.get("startFadeOut").getAsInt(), wrapper.get("endFadeOut").getAsInt(), false)).maxAlpha(maxAlpha).transitionInDuration((int)(maxAlpha / wrapper.getOptionalFloat("transitionSpeed", 0.05f))).transitionOutDuration((int)(maxAlpha / wrapper.getOptionalFloat("transitionSpeed", 0.05f))).changeFog(wrapper.getOptionalBoolean("changeFog", false)).fogColors(new RGBA(wrapper.getOptionalFloat("fogRed", 0.0f), wrapper.getOptionalFloat("fogGreen", 0.0f), wrapper.getOptionalFloat("fogBlue", 0.0f))).build();
        skybox.decorations = Decorations.DEFAULT;
        JsonElement element = wrapper.getOptionalValue("weather").orElse(null);
        if (element != null) {
            if (element.isJsonArray()) {
                for (JsonElement jsonElement : element.getAsJsonArray()) {
                    skybox.conditions.getWeathers().add(Weather.fromString(jsonElement.getAsString()));
                }
            } else if (class_3518.method_15286((JsonElement)element)) {
                skybox.conditions.getWeathers().add(Weather.fromString(element.getAsString()));
            }
        }
        element = wrapper.getOptionalValue("biomes").orElse(null);
        LegacyDeserializer.processIds(element, skybox.conditions.getBiomes());
        element = wrapper.getOptionalValue("dimensions").orElse(null);
        LegacyDeserializer.processIds(element, skybox.conditions.getWorlds());
        element = wrapper.getOptionalValue("heightRanges").orElse(null);
        if (element != null) {
            JsonArray array = element.getAsJsonArray();
            for (JsonElement jsonElement : array) {
                JsonArray insideArray = jsonElement.getAsJsonArray();
                float low = insideArray.get(0).getAsFloat();
                float high = insideArray.get(1).getAsFloat();
                skybox.conditions.getYRanges().add(new MinMaxEntry(low, high));
            }
        }
    }

    private static void processIds(JsonElement element, List<class_2960> list) {
        if (element != null) {
            if (element.isJsonArray()) {
                for (JsonElement jsonElement : element.getAsJsonArray()) {
                    list.add(new class_2960(jsonElement.getAsString()));
                }
            } else if (class_3518.method_15286((JsonElement)element)) {
                list.add(new class_2960(element.getAsString()));
            }
        }
    }

    private static <T extends AbstractSkybox> LegacyDeserializer<T> register(LegacyDeserializer<T> deserializer, String name) {
        return (LegacyDeserializer)class_2378.method_10230(REGISTRY, (class_2960)new class_2960("fabricskyboxes", name), deserializer);
    }

    public BiConsumer<JsonObjectWrapper, AbstractSkybox> getDeserializer() {
        return this.deserializer;
    }
}

