/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import com.google.common.base.Strings;
import journeymap.client.command.ClientCommandInvoker;
import journeymap.client.command.CmdChatPosition;
import journeymap.client.command.CmdEditWaypoint;
import journeymap.client.command.CmdReloadWaypoint;
import journeymap.client.waypoint.WaypointParser;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_2165;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class ChatEventHandler {
    private final ClientCommandInvoker clientCommandInvoker = new ClientCommandInvoker();

    public ChatEventHandler() {
        this.clientCommandInvoker.registerSub(new CmdChatPosition());
        this.clientCommandInvoker.registerSub(new CmdEditWaypoint());
        this.clientCommandInvoker.registerSub(new CmdReloadWaypoint());
    }

    public class_2561 onClientChatEventReceived(class_2561 message) {
        if (message != null) {
            try {
                String text = message.getString();
                if (!Strings.isNullOrEmpty((String)text)) {
                    return WaypointParser.parseChatForWaypoints(message, text);
                }
            }
            catch (Exception e) {
                Journeymap.getLogger().warn("Unexpected exception on ClientChatReceivedEvent: " + LogFormatter.toString(e));
            }
        }
        return message;
    }

    public boolean onChatEvent(String message) {
        if (message.regionMatches(0, "/jm", 0, 3)) {
            if (message.length() > 3) {
                class_746 player = class_310.method_1551().field_1724;
                message = message.substring(4);
                this.clientCommandInvoker.execute((class_2165)player, message.split(" "));
            } else {
                String commands = this.clientCommandInvoker.getPossibleCommands();
                String text = "Available sub commands are: " + commands;
                class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)text));
            }
            return true;
        }
        return false;
    }
}

