/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.dailyshop.data.adapter.nbt;

import bigchadguys.dailyshop.data.adapter.ISimpleAdapter;
import bigchadguys.dailyshop.data.bit.BitBuffer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.class_2520;

public abstract class NbtAdapter<T extends class_2520>
implements ISimpleAdapter<T, class_2520, JsonElement> {
    private final boolean nullable;

    public NbtAdapter(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    protected abstract void writeTagBits(T var1, BitBuffer var2);

    protected abstract T readTagBits(BitBuffer var1);

    protected abstract void writeTagBytes(T var1, ByteBuf var2);

    protected abstract T readTagBytes(ByteBuf var1);

    protected abstract void writeTagData(T var1, DataOutput var2) throws IOException;

    protected abstract T readTagData(DataInput var1) throws IOException;

    protected abstract class_2520 writeTagNbt(T var1);

    protected abstract T readTagNbt(class_2520 var1);

    protected abstract JsonElement writeTagJson(T var1);

    protected abstract T readTagJson(JsonElement var1);

    @Override
    public void writeBits(T value, BitBuffer buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            this.writeTagBits(value, buffer);
        }
    }

    @Override
    public Optional<T> readBits(BitBuffer buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(this.readTagBits(buffer));
    }

    @Override
    public void writeBytes(T value, ByteBuf buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            this.writeTagBytes(value, buffer);
        }
    }

    @Override
    public Optional<T> readBytes(ByteBuf buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(this.readTagBytes(buffer));
    }

    @Override
    public void writeData(T value, DataOutput data) throws IOException {
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            this.writeTagData(value, data);
        }
    }

    @Override
    public Optional<T> readData(DataInput data) throws IOException {
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(this.readTagData(data));
    }

    @Override
    public Optional<class_2520> writeNbt(T value) {
        return value == null ? Optional.empty() : Optional.ofNullable(this.writeTagNbt(value));
    }

    @Override
    public Optional<T> readNbt(class_2520 nbt) {
        return nbt == null ? Optional.empty() : Optional.ofNullable(this.readTagNbt(nbt));
    }

    @Override
    public Optional<JsonElement> writeJson(T value) {
        return value == null ? Optional.empty() : Optional.ofNullable(this.writeTagJson(value));
    }

    @Override
    public Optional<T> readJson(JsonElement json) {
        return json == null || json instanceof JsonNull ? Optional.empty() : Optional.ofNullable(this.readTagJson(json));
    }
}

