/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.dailyshop.data.adapter.number;

import bigchadguys.dailyshop.data.adapter.number.NumberAdapter;
import bigchadguys.dailyshop.data.bit.BitBuffer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.class_2499;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class ByteAdapter
extends NumberAdapter<Byte> {
    public ByteAdapter(boolean nullable) {
        super(nullable);
    }

    public ByteAdapter asNullable() {
        return new ByteAdapter(true);
    }

    @Override
    protected void writeNumberBits(Byte value, BitBuffer buffer) {
        buffer.writeByte(value);
    }

    @Override
    protected Byte readNumberBits(BitBuffer buffer) {
        return buffer.readByte();
    }

    @Override
    protected void writeNumberBytes(Byte value, ByteBuf buffer) {
        buffer.writeByte((int)value.byteValue());
    }

    @Override
    protected Byte readNumberBytes(ByteBuf buffer) {
        return buffer.readByte();
    }

    @Override
    protected void writeNumberData(Byte value, DataOutput data) throws IOException {
        data.writeByte(value.byteValue());
    }

    @Override
    protected Byte readNumberData(DataInput data) throws IOException {
        return data.readByte();
    }

    @Override
    protected class_2520 writeNumberNbt(Byte value) {
        return ByteAdapter.wrap(ByteAdapter.reduce(value));
    }

    @Override
    protected Byte readNumberNbt(class_2520 nbt) {
        class_2499 list;
        if (nbt instanceof class_2514) {
            class_2514 numeric = (class_2514)nbt;
            return numeric.method_10698();
        }
        if (nbt instanceof class_2499 && (list = (class_2499)nbt).size() == 1) {
            return this.readNumberNbt(list.method_10534(0));
        }
        if (nbt instanceof class_2519) {
            class_2519 string = (class_2519)nbt;
            return ByteAdapter.parse(string.toString()).map(Number::byteValue).orElse(null);
        }
        return null;
    }

    @Override
    protected JsonElement writeNumberJson(Byte value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    protected Byte readNumberJson(JsonElement json) {
        JsonArray array;
        if (json instanceof JsonObject) {
            return null;
        }
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 1) {
            return this.readNumberJson(array.get(0));
        }
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            if (primitive.isNumber()) {
                return primitive.getAsByte();
            }
            if (primitive.isString()) {
                return ByteAdapter.parse(primitive.getAsString()).map(Number::byteValue).orElse(null);
            }
        }
        return null;
    }
}

