/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.dailyshop.data.adapter.number;

import bigchadguys.dailyshop.data.adapter.ISimpleAdapter;
import bigchadguys.dailyshop.data.bit.BitBuffer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.class_2516;
import net.minecraft.class_2520;

public class CharAdapter
implements ISimpleAdapter<Character, class_2520, JsonElement> {
    private final boolean nullable;

    public CharAdapter(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public CharAdapter asNullable() {
        return new CharAdapter(true);
    }

    @Override
    public final void writeBits(Character value, BitBuffer buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeChar(value.charValue());
        }
    }

    @Override
    public final Optional<Character> readBits(BitBuffer buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(Character.valueOf(buffer.readChar()));
    }

    @Override
    public final void writeBytes(Character value, ByteBuf buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeChar((int)value.charValue());
        }
    }

    @Override
    public final Optional<Character> readBytes(ByteBuf buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(Character.valueOf(buffer.readChar()));
    }

    @Override
    public void writeData(Character value, DataOutput data) throws IOException {
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            data.writeChar(value.charValue());
        }
    }

    @Override
    public Optional<Character> readData(DataInput data) throws IOException {
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(Character.valueOf(data.readChar()));
    }

    @Override
    public final Optional<class_2520> writeNbt(Character value) {
        return value == null ? Optional.empty() : Optional.of(class_2516.method_23254((short)((short)value.charValue())));
    }

    @Override
    public final Optional<Character> readNbt(class_2520 nbt) {
        Optional<Character> optional;
        if (nbt instanceof class_2516) {
            class_2516 tag = (class_2516)nbt;
            optional = Optional.of(Character.valueOf((char)Short.toUnsignedInt(tag.method_10696())));
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public final Optional<JsonElement> writeJson(Character value) {
        return value == null ? Optional.empty() : Optional.of(new JsonPrimitive(value));
    }

    @Override
    public final Optional<Character> readJson(JsonElement json) {
        JsonPrimitive primitive;
        JsonArray array;
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 1) {
            return this.readJson(array.get(0));
        }
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
            return Optional.of(Character.valueOf(primitive.getAsString().charAt(0)));
        }
        return Optional.empty();
    }
}

