/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.dailyshop.data.adapter.util;

import bigchadguys.dailyshop.data.adapter.Adapters;
import bigchadguys.dailyshop.data.adapter.IAdapter;
import bigchadguys.dailyshop.data.adapter.ISimpleAdapter;
import bigchadguys.dailyshop.data.bit.BitBuffer;
import bigchadguys.dailyshop.util.WeightedTree;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public abstract class WeightedTreeAdapter<T, W extends WeightedTree<T>>
implements ISimpleAdapter<W, class_2499, JsonArray> {
    public abstract W create();

    public abstract String getName(T var1);

    public abstract IAdapter getAdapter(String var1);

    @Override
    public void writeBits(W value, BitBuffer buffer) {
        if (value == null) {
            buffer.writeBoolean(false);
            return;
        }
        buffer.writeBoolean(true);
        Adapters.INT_SEGMENTED_7.writeBits(((WeightedTree)value).getChildren().size(), buffer);
        ((WeightedTree)value).getChildren().forEach((branch, weight) -> {
            buffer.writeBoolean(branch instanceof WeightedTree);
            buffer.writeDouble((double)weight);
            if (branch instanceof WeightedTree) {
                this.writeBits((W)((WeightedTree)branch), buffer);
            } else {
                String name = this.getName(branch);
                buffer.writeString(name);
                this.getAdapter(name).writeBits(branch, buffer, null);
            }
        });
    }

    @Override
    public Optional<W> readBits(BitBuffer buffer) {
        if (!buffer.readBoolean()) {
            return Optional.empty();
        }
        int groupSize = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        Object tree = this.create();
        for (int i = 0; i < groupSize; ++i) {
            boolean isTree = buffer.readBoolean();
            double weight = buffer.readDouble();
            if (isTree) {
                this.readBits(buffer).ifPresent(w -> tree.addTree(w, weight));
                continue;
            }
            String name = buffer.readString();
            IAdapter adapter = this.getAdapter(name);
            if (adapter == null) continue;
            adapter.readBits(buffer, null).ifPresent(o -> tree.addLeaf(o, weight));
        }
        return Optional.of(tree);
    }

    @Override
    public Optional<class_2499> writeNbt(W value) {
        if (value == null) {
            return Optional.empty();
        }
        class_2499 list = new class_2499();
        ((WeightedTree)value).getChildren().forEach((branch, weight) -> {
            class_2487 compound = new class_2487();
            compound.method_10549("weight", weight.doubleValue());
            if (branch instanceof WeightedTree) {
                this.writeNbt((W)((WeightedTree)branch)).ifPresent(element -> compound.method_10566("pool", (class_2520)element));
            } else {
                String name = this.getName(branch);
                this.getAdapter(name).writeNbt(branch, null).ifPresent(element -> compound.method_10566(name, (class_2520)element));
            }
            list.add((Object)compound);
        });
        return Optional.of(list);
    }

    @Override
    public Optional<W> readNbt(class_2499 nbt) {
        if (nbt == null) {
            return Optional.empty();
        }
        Object tree = this.create();
        for (int i = 0; i < nbt.size(); ++i) {
            class_2487 element = nbt.method_10602(i);
            double weight = element.method_10574("weight");
            HashSet keys = new HashSet(element.method_10541());
            keys.remove("weight");
            String name = (String)keys.iterator().next();
            if (name.equals("pool")) {
                this.readNbt(element.method_10554(name, 10)).ifPresent(w -> tree.addTree(w, weight));
                continue;
            }
            IAdapter adapter = this.getAdapter(name);
            if (adapter == null) continue;
            adapter.readNbt(element.method_10580(name), null).ifPresent(o -> tree.addLeaf(o, weight));
        }
        return Optional.of(tree);
    }

    @Override
    public Optional<JsonArray> writeJson(W value) {
        if (value == null) {
            return Optional.empty();
        }
        JsonArray array = new JsonArray();
        ((WeightedTree)value).getChildren().forEach((branch, weight) -> {
            JsonObject object;
            if (branch instanceof WeightedTree) {
                object = new JsonObject();
                this.writeJson((W)((WeightedTree)branch)).ifPresent(element -> object.add("pool", (JsonElement)element));
            } else {
                String name = this.getName(branch);
                Object element2 = this.getAdapter(name).writeJson(branch, null).orElse(null);
                if (name == null) {
                    if (!(element2 instanceof JsonObject)) throw new UnsupportedOperationException("Cannot write " + element2);
                    object = element2;
                } else {
                    object = new JsonObject();
                    object.add(name, (JsonElement)element2);
                }
            }
            object.addProperty("weight", (Number)weight);
            array.add((JsonElement)object);
        });
        return Optional.of(array);
    }

    @Override
    public Optional<W> readJson(JsonArray json) {
        if (json == null) {
            return Optional.empty();
        }
        Object tree = this.create();
        for (int i = 0; i < json.size(); ++i) {
            JsonObject element = json.get(i).getAsJsonObject();
            double weight = element.get("weight").getAsDouble();
            String name = null;
            if (element.keySet().size() == 2) {
                HashSet keys = new HashSet(element.keySet());
                keys.remove("weight");
                name = (String)keys.iterator().next();
            }
            if (name.equals("pool")) {
                this.readJson(element.get(name).getAsJsonArray()).ifPresent(w -> tree.addTree(w, weight));
                continue;
            }
            IAdapter adapter = this.getAdapter(name);
            if (adapter == null) continue;
            adapter.readJson(name == null ? element : element.get(name), null).ifPresent(o -> tree.addLeaf(o, weight));
        }
        return Optional.of(tree);
    }
}

