/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.dailyshop.screen;

import bigchadguys.dailyshop.DailyShopMod;
import bigchadguys.dailyshop.init.ModNetwork;
import bigchadguys.dailyshop.net.DailyShopTradeC2SPacket;
import bigchadguys.dailyshop.screen.handler.DailyShopScreenHandler;
import bigchadguys.dailyshop.trade.EmptyShop;
import bigchadguys.dailyshop.trade.Trade;
import bigchadguys.dailyshop.util.ClientScheduler;
import bigchadguys.dailyshop.util.TradeExecutor;
import bigchadguys.dailyshop.world.data.DailyShopData;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class DailyShopScreen
extends class_465<DailyShopScreenHandler> {
    private static final class_2960 TEXTURE = DailyShopMod.id("textures/gui/daily_shop.png");
    private static final class_2561 TRADES_TEXT = class_2561.method_43471((String)"merchant.trades");
    private final OfferWidget[] offers;
    private int scrollOffset;
    private boolean scrolling;
    private int hoveredTrade;

    public DailyShopScreen(DailyShopScreenHandler handler, class_1661 playerInventory, class_2561 title) {
        super((class_1703)handler, playerInventory, title);
        this.field_2792 = 276;
        this.field_25269 = 107;
        this.offers = new OfferWidget[7];
        this.scrollOffset = 0;
        this.hoveredTrade = -1;
    }

    public List<Trade> getTrades() {
        return DailyShopData.CLIENT.getShop(((DailyShopScreenHandler)this.field_2797).getId()).orElse(EmptyShop.INSTANCE).getTrades().toList();
    }

    public TradeExecutor.Result getResult(int index) {
        List<Trade> trades = this.getTrades();
        if (index >= 0 && index < trades.size()) {
            return TradeExecutor.test(trades.get(index), this.field_2797);
        }
        return null;
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = (this.field_22789 - this.field_2792) / 2 - 1;
        int centerY = (this.field_22790 - this.field_2779) / 2 - 1;
        int x = centerX + 5;
        int y = centerY + 18;
        for (int i = 0; i < 7; ++i) {
            this.offers[i] = (OfferWidget)this.method_37063((class_364)new OfferWidget(x, y, i, button -> {
                if (!(button instanceof OfferWidget)) {
                    return;
                }
                OfferWidget offer = (OfferWidget)button;
                ModNetwork.CHANNEL.sendToServer((Object)new DailyShopTradeC2SPacket(this.scrollOffset + offer.getIndex()));
            }));
            y += 20;
        }
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        context.method_51439(this.field_22793, this.field_22785, 49 + this.field_2792 / 2 - this.field_22793.method_27525((class_5348)this.field_22785) / 2, 6, 0x404040, false);
        context.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, 0x404040, false);
        int l = this.field_22793.method_27525((class_5348)TRADES_TEXT);
        context.method_51439(this.field_22793, TRADES_TEXT, 5 - l / 2 + 48, 6, 0x404040, false);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        int centerX = (this.field_22789 - this.field_2792) / 2 - 1;
        int centerY = (this.field_22790 - this.field_2779) / 2 - 1;
        context.method_25291(TEXTURE, centerX, centerY, 0, 0.0f, 0.0f, this.field_2792, this.field_2779, 512, 256);
    }

    private void renderScrollbar(class_332 context, int x, int y, List<Trade> trades) {
        int i = trades.size() + 1 - 7;
        if (i > 1) {
            int j = 139 - (27 + (i - 1) * 139 / i);
            int k = 1 + j / i + 139 / i;
            int l = 113;
            int m = Math.min(113, this.scrollOffset * k);
            if (this.scrollOffset == i - 1) {
                m = 113;
            }
            context.method_25291(TEXTURE, x + 94, y + 18 + m, 0, 0.0f, 199.0f, 6, 27, 512, 256);
        } else {
            context.method_25291(TEXTURE, x + 94, y + 18, 0, 6.0f, 199.0f, 6, 27, 512, 256);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        super.method_25394(context, mouseX, mouseY, delta);
        this.renderInventoryHighlight(context);
        double time = (float)ClientScheduler.TICK + delta;
        List<Trade> trades = this.getTrades();
        if (!trades.isEmpty()) {
            int i = (this.field_22789 - this.field_2792) / 2 - 1;
            int j = (this.field_22790 - this.field_2779) / 2 - 1;
            int k = j + 16 + 1;
            int l = i + 5 + 5;
            this.renderScrollbar(context, i, j, trades);
            int m = 0;
            for (Trade trade : trades) {
                if (this.canScroll(trades.size()) && (m < this.scrollOffset || m >= 7 + this.scrollOffset)) {
                    ++m;
                    continue;
                }
                class_1799 input1 = trade.getInput(1).getDisplay(time);
                class_1799 input2 = trade.getInput(2).getDisplay(time);
                class_1799 input3 = trade.getInput(3).getDisplay(time);
                class_1799 output = trade.getOutput();
                TradeExecutor.Result result = TradeExecutor.test(trade, this.field_2797);
                context.method_51448().method_22903();
                context.method_51448().method_46416(0.0f, 0.0f, 100.0f);
                int n = k + 2;
                if (!input1.method_7960()) {
                    context.method_51445(input1, l - 2, n);
                    if (!result.checkInput(1)) {
                        RenderSystem.setShaderColor((float)1.0f, (float)0.332f, (float)0.332f, (float)1.0f);
                    }
                    context.method_51431(this.field_22793, input1, l - 2, n);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                if (!input2.method_7960()) {
                    context.method_51445(input2, i + 25, n);
                    if (!result.checkInput(2)) {
                        RenderSystem.setShaderColor((float)1.0f, (float)0.332f, (float)0.332f, (float)1.0f);
                    }
                    context.method_51431(this.field_22793, input2, i + 25, n);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                if (!input3.method_7960()) {
                    context.method_51445(input3, i + 42, n);
                    if (!result.checkInput(3)) {
                        RenderSystem.setShaderColor((float)1.0f, (float)0.332f, (float)0.332f, (float)1.0f);
                    }
                    context.method_51431(this.field_22793, input3, i + 42, n);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                RenderSystem.enableBlend();
                if (!trade.isAvailable()) {
                    context.method_25291(TEXTURE, i + 2 + 35 + 25, n + 4, 0, 25.0f, 171.0f, 10, 9, 512, 256);
                } else {
                    context.method_25291(TEXTURE, i + 2 + 35 + 25, n + 4, 0, 15.0f, 171.0f, 10, 9, 512, 256);
                }
                if (!output.method_7960()) {
                    context.method_51445(output, i + 3 + 70, n);
                    if (!result.checkOutput()) {
                        RenderSystem.setShaderColor((float)1.0f, (float)0.332f, (float)0.332f, (float)1.0f);
                    }
                    context.method_51431(this.field_22793, output, i + 3 + 70, n);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                context.method_51448().method_22909();
                k += 20;
                ++m;
            }
            for (OfferWidget offer : this.offers) {
                if (offer.method_25367()) {
                    offer.renderTooltip(context, mouseX, mouseY, time);
                }
                offer.field_22764 = offer.index < this.getTrades().size();
            }
            RenderSystem.enableDepthTest();
        }
        this.method_2380(context, mouseX, mouseY);
    }

    private void renderInventoryHighlight(class_332 context) {
        class_1735 slot;
        this.hoveredTrade = -1;
        for (OfferWidget offer : this.offers) {
            if (!offer.method_49606()) continue;
            this.hoveredTrade = offer.index + this.scrollOffset;
        }
        TradeExecutor.Result result = this.getResult(this.hoveredTrade);
        if (result == null) {
            return;
        }
        RenderSystem.disableDepthTest();
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)this.field_2776, (float)this.field_2800, 0.0f);
        for (Integer index : result.getUsedSlots()) {
            slot = ((DailyShopScreenHandler)this.field_2797).method_7611(index);
            context.method_51740(class_1921.method_51785(), slot.field_7873, slot.field_7872, slot.field_7873 + 16, slot.field_7872 + 16, 0x6555FF55, 0x6555FF55, 0);
        }
        for (Integer index : result.getIncompleteSlots()) {
            slot = ((DailyShopScreenHandler)this.field_2797).method_7611(index);
            context.method_51740(class_1921.method_51785(), slot.field_7873, slot.field_7872, slot.field_7873 + 16, slot.field_7872 + 16, 0x65FF5555, 0x65FF5555, 0);
        }
        context.method_51448().method_22909();
        RenderSystem.enableDepthTest();
    }

    private boolean canScroll(int listSize) {
        return listSize > 7;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        int i = this.getTrades().size();
        if (this.canScroll(i)) {
            int j = i - 7;
            this.scrollOffset = class_3532.method_15340((int)((int)((double)this.scrollOffset - amount)), (int)0, (int)j);
        }
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling) {
            int j = this.field_2800 + 18;
            int k = j + 139;
            int l = this.getTrades().size() - 7;
            float f = ((float)mouseY - (float)j - 13.5f) / ((float)(k - j) - 27.0f);
            f = f * (float)l + 0.5f;
            this.scrollOffset = class_3532.method_15340((int)((int)f), (int)0, (int)l);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        int i = (this.field_22789 - this.field_2792) / 2 - 1;
        int j = (this.field_22790 - this.field_2779) / 2 - 1;
        if (this.canScroll(this.getTrades().size()) && mouseX > (double)(i + 94) && mouseX < (double)(i + 94 + 6) && mouseY > (double)(j + 18) && mouseY <= (double)(j + 18 + 139 + 1)) {
            this.scrolling = true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public class OfferWidget
    extends class_4185 {
        final int index;

        public OfferWidget(int x, int y, int index, class_4185.class_4241 onPress) {
            super(x, y, 88, 20, class_5244.field_39003, onPress, field_40754);
            this.index = index;
            this.field_22764 = false;
        }

        public int getIndex() {
            return this.index;
        }

        public void renderTooltip(class_332 context, int x, int y, double time) {
            List<Trade> trades = DailyShopScreen.this.getTrades();
            int index = this.index + DailyShopScreen.this.scrollOffset;
            if (this.field_22762 && trades.size() > index) {
                class_1799 stack = class_1799.field_8037;
                if (x >= this.method_46426() + 4 && x < this.method_46426() + 20) {
                    stack = trades.get(index).getInput(1).getDisplay(time);
                } else if (x >= this.method_46426() + 20 && x < this.method_46426() + 36) {
                    stack = trades.get(index).getInput(2).getDisplay(time);
                } else if (x >= this.method_46426() + 36 && x < this.method_46426() + 52) {
                    stack = trades.get(index).getInput(3).getDisplay(time);
                } else if (x > this.method_46426() + 65) {
                    stack = trades.get(index).getOutput();
                }
                if (!stack.method_7960()) {
                    context.method_51446(DailyShopScreen.this.field_22793, stack, x, y);
                }
            }
        }
    }
}

