/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.dailyshop.world.data;

import bigchadguys.dailyshop.DailyShopMod;
import bigchadguys.dailyshop.data.adapter.Adapters;
import bigchadguys.dailyshop.data.bit.BitBuffer;
import bigchadguys.dailyshop.data.serializable.ISerializable;
import bigchadguys.dailyshop.init.ModConfigs;
import bigchadguys.dailyshop.init.ModNetwork;
import bigchadguys.dailyshop.init.ModWorldData;
import bigchadguys.dailyshop.net.DailyShopUpdateS2CPacket;
import bigchadguys.dailyshop.trade.Shop;
import bigchadguys.dailyshop.world.data.WorldData;
import bigchadguys.dailyshop.world.random.JavaRandom;
import com.google.gson.JsonObject;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class DailyShopData
extends WorldData {
    public static final DailyShopData CLIENT = new DailyShopData();
    private final Map<String, Entry> entries = new LinkedHashMap<String, Entry>();

    public Map<String, Entry> getEntries() {
        return this.entries;
    }

    public Optional<Shop> getShop(String id) {
        return Optional.ofNullable(this.entries.get(id)).map(entry -> entry.shop);
    }

    public void onAcknowledge(String id, class_1657 player) {
        Entry entry = this.entries.get(id);
        if (entry == null) {
            return;
        }
        entry.acknowledgments.add(player.method_5667());
        if (player.method_5682() != null) {
            for (class_3222 other : player.method_5682().method_3760().method_14571()) {
                ModNetwork.CHANNEL.sendToPlayer(other, (Object)new DailyShopUpdateS2CPacket(id, entry));
            }
        }
    }

    public void setShop(String id, Shop shop, MinecraftServer server) {
        if (shop == null) {
            this.entries.remove(id);
        } else {
            Entry entry = new Entry(shop, System.currentTimeMillis());
            this.entries.put(id, entry);
            shop.setChangeListener(this, () -> {
                for (class_3222 player : server.method_3760().method_14571()) {
                    ModNetwork.CHANNEL.sendToPlayer(player, (Object)new DailyShopUpdateS2CPacket(id, entry));
                }
                this.method_78(true);
            });
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            ModNetwork.CHANNEL.sendToPlayer(player, (Object)new DailyShopUpdateS2CPacket(id, this.entries.get(id)));
        }
    }

    public void reset() {
        this.entries.clear();
        this.method_78(true);
    }

    public void onTick(MinecraftServer server) {
        LinkedHashMap<String, Entry> changes = new LinkedHashMap<String, Entry>();
        ModConfigs.DAILY_SHOP.getShops().forEach((id, entry) -> {
            if (!this.entries.containsKey(id) || entry.shouldUpdate(this.entries.get((Object)id).lastUpdated)) {
                this.setShop((String)id, entry.generate(JavaRandom.ofNanoTime()), server);
                if (id == null) {
                    DailyShopMod.LOGGER.info("Refreshed daily shop!");
                } else {
                    DailyShopMod.LOGGER.info("Refreshed daily shop %s!".formatted(id));
                }
                changes.put((String)id, this.entries.get(id));
            }
        });
        this.entries.keySet().removeIf(id -> {
            if (!ModConfigs.DAILY_SHOP.getShops().containsKey(id)) {
                changes.put((String)id, (Entry)null);
                return true;
            }
            return false;
        });
        if (!changes.isEmpty()) {
            this.method_78(true);
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            ModNetwork.CHANNEL.sendToPlayer(player, (Object)new DailyShopUpdateS2CPacket(changes));
        }
    }

    @Override
    public Optional<class_2487> writeNbt() {
        class_2487 nbt = new class_2487();
        if (this.entries.containsKey(null)) {
            this.entries.get(null).writeNbt().ifPresent(tag -> nbt.method_10566("default", (class_2520)tag));
        }
        class_2487 custom = new class_2487();
        this.entries.forEach((id, entry) -> {
            if (id == null) {
                return;
            }
            entry.writeNbt().ifPresent(tag -> custom.method_10566(id, (class_2520)tag));
        });
        nbt.method_10566("custom", (class_2520)custom);
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.entries.clear();
        if (!nbt.method_10545("custom")) {
            Shop shop = Adapters.SHOP.readNbt(nbt.method_10580("shop")).orElse(null);
            long lastUpdated = Adapters.LONG.readNbt(nbt.method_10580("lastUpdated")).orElse(0L);
            if (shop != null) {
                this.entries.put(null, new Entry(shop, lastUpdated));
            }
        } else {
            if (nbt.method_10545("default")) {
                Entry entry = new Entry(null, 0L);
                entry.readNbt(nbt.method_10562("default"));
                if (entry.shop != null) {
                    this.entries.put(null, entry);
                }
            }
            class_2487 custom = nbt.method_10562("custom");
            for (String id : custom.method_10541()) {
                Entry entry = new Entry(null, 0L);
                entry.readNbt(custom.method_10562(id));
                if (entry.shop == null) continue;
                this.entries.put(id, entry);
            }
        }
    }

    public static void initCommon() {
        PlayerEvent.PLAYER_JOIN.register(player -> {
            DailyShopData data = ModWorldData.DAILY_SHOP.getGlobal((class_1937)player.method_51469());
            ModNetwork.CHANNEL.sendToPlayer(player, (Object)new DailyShopUpdateS2CPacket(data.entries));
        });
        TickEvent.SERVER_POST.register(server -> {
            DailyShopData data = ModWorldData.DAILY_SHOP.getGlobal((MinecraftServer)server);
            data.onTick((MinecraftServer)server);
        });
    }

    public static class Entry
    implements ISerializable<class_2487, JsonObject> {
        private Shop shop;
        private long lastUpdated;
        private final Set<UUID> acknowledgments;

        public Entry() {
            this.acknowledgments = new HashSet<UUID>();
        }

        public Entry(Shop shop, long lastUpdated) {
            this.shop = shop;
            this.lastUpdated = lastUpdated;
            this.acknowledgments = new HashSet<UUID>();
        }

        public Shop getShop() {
            return this.shop;
        }

        public long getLastUpdated() {
            return this.lastUpdated;
        }

        public Set<UUID> getAcknowledgments() {
            return this.acknowledgments;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.SHOP.writeBits(this.shop, buffer);
            Adapters.LONG.writeBits(this.lastUpdated, buffer);
            Adapters.INT_SEGMENTED_3.writeBits(this.acknowledgments.size(), buffer);
            this.acknowledgments.forEach(uuid -> Adapters.UUID.writeBits((UUID)uuid, buffer));
        }

        @Override
        public void readBits(BitBuffer buffer) {
            this.shop = (Shop)Adapters.SHOP.readBits(buffer).orElseThrow();
            this.lastUpdated = (Long)Adapters.LONG.readBits(buffer).orElseThrow();
            int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
            this.acknowledgments.clear();
            for (int i = 0; i < size; ++i) {
                this.acknowledgments.add(Adapters.UUID.readBits(buffer).orElseThrow());
            }
        }

        @Override
        public Optional<class_2487> writeNbt() {
            return Optional.of(new class_2487()).map(nbt -> {
                Adapters.SHOP.writeNbt(this.shop).ifPresent(value -> nbt.method_10566("shop", value));
                Adapters.LONG.writeNbt(this.lastUpdated).ifPresent(value -> nbt.method_10566("lastUpdated", value));
                class_2499 acknowledgments = new class_2499();
                this.acknowledgments.forEach(player -> Adapters.UUID.writeNbt((UUID)player).ifPresent(arg_0 -> acknowledgments.add(arg_0)));
                nbt.method_10566("acknowledgments", (class_2520)acknowledgments);
                return nbt;
            });
        }

        @Override
        public void readNbt(class_2487 nbt) {
            this.shop = Adapters.SHOP.readNbt(nbt.method_10580("shop")).orElse(null);
            this.lastUpdated = Adapters.LONG.readNbt(nbt.method_10580("lastUpdated")).orElse(0L);
            this.acknowledgments.clear();
            class_2520 class_25202 = nbt.method_10580("acknowledgments");
            if (class_25202 instanceof class_2499) {
                class_2499 acknowledgments = (class_2499)class_25202;
                for (class_2520 element : acknowledgments) {
                    Adapters.UUID.readNbt(element).ifPresent(uuid -> this.acknowledgments.add((UUID)uuid));
                }
            }
        }
    }
}

