/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IJsonConfig;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginInfo;
import mcp.mobius.waila.api.IWailaClientPlugin;
import mcp.mobius.waila.api.IWailaCommonPlugin;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.plugin.PluginSide;
import mcp.mobius.waila.util.CachedSupplier;
import mcp.mobius.waila.util.Log;
import mcp.mobius.waila.util.ModInfo;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class PluginInfo
implements IPluginInfo {
    private static final Log LOG = Log.create();
    private static final class_2960 CORE = Waila.id("core");
    private static final IJsonConfig<Map<class_2960, Boolean>> TOGGLE = IJsonConfig.of(new TypeToken<Map<class_2960, Boolean>>(){}).file("waila/plugin_toggle").factory(LinkedHashMap::new).json5().gson(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).create()).build();
    private static final Map<class_2960, PluginInfo> PLUGIN_ID_TO_PLUGIN_INFO = new LinkedHashMap<class_2960, PluginInfo>();
    private static final CachedSupplier<Map<String, List<PluginInfo>>> MOD_ID_TO_PLUGIN_INFOS = new CachedSupplier<Map>(() -> PLUGIN_ID_TO_PLUGIN_INFO.values().stream().collect(Collectors.groupingBy(p -> p.getModInfo().getId())));
    private static final IWailaPlugin EMPTY_INIT = registrar -> {};
    private final ModInfo modInfo;
    private final class_2960 pluginId;
    private final PluginSide side;
    private final List<String> requiredModIds;
    private final boolean legacy;
    @Nullable
    private final IWailaPlugin deprecatedInit;
    @Nullable
    private final @Nullable java.util.function.Supplier<@Nullable IWailaCommonPlugin> common;
    @Nullable
    private final @Nullable java.util.function.Supplier<@Nullable IWailaClientPlugin> client;
    private boolean disabledOnServer;

    private PluginInfo(ModInfo modInfo, class_2960 pluginId, PluginSide side, @Nullable IWailaPlugin deprecatedInit, List<String> requiredModIds, boolean legacy, @Nullable @Nullable java.util.function.Supplier<@Nullable IWailaCommonPlugin> common, @Nullable @Nullable java.util.function.Supplier<@Nullable IWailaClientPlugin> client) {
        this.modInfo = modInfo;
        this.pluginId = pluginId;
        this.side = side;
        this.deprecatedInit = deprecatedInit;
        this.requiredModIds = requiredModIds;
        this.legacy = legacy;
        this.common = common;
        this.client = client;
    }

    private static boolean isDuplicate(class_2960 rl) {
        if (PLUGIN_ID_TO_PLUGIN_INFO.containsKey(rl)) {
            LOG.error("Duplicate plugin id " + rl);
            return true;
        }
        return false;
    }

    public static void register(String modId, String pluginIdStr, PluginSide side, @Nullable String commonCls, @Nullable String clientCls, List<String> required, boolean defaultEnabled) {
        class_2960 rl = new class_2960(pluginIdStr);
        if (PluginInfo.isDuplicate(rl)) {
            return;
        }
        if (rl.method_12836().equals("minecraft")) {
            LOG.warn("Plugin " + commonCls + " is using the default namespace " + rl);
        }
        Supplier common = commonCls == null ? null : Suppliers.memoize(() -> {
            try {
                return (IWailaCommonPlugin)Class.forName(commonCls).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                LOG.error("Error creating instance of plugin " + pluginIdStr, t);
                return null;
            }
        });
        Supplier client = clientCls == null ? null : Suppliers.memoize(() -> {
            try {
                return (IWailaClientPlugin)Class.forName(clientCls).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                LOG.error("Error creating instance of plugin " + pluginIdStr, t);
                return null;
            }
        });
        PLUGIN_ID_TO_PLUGIN_INFO.put(rl, new PluginInfo(ModInfo.get(modId), rl, side, null, required, false, (java.util.function.Supplier<IWailaCommonPlugin>)common, (java.util.function.Supplier<IWailaClientPlugin>)client));
        TOGGLE.get().put(rl, defaultEnabled);
    }

    public static void registerDeprecated(String modId, String pluginIdStr, PluginSide side, String initializerStr, List<String> required, boolean defaultEnabled, boolean legacy) {
        try {
            class_2960 rl = new class_2960(pluginIdStr);
            if (PluginInfo.isDuplicate(rl)) {
                return;
            }
            if (rl.method_12836().equals("minecraft")) {
                LOG.warn("Plugin " + initializerStr + " is using the default namespace " + rl);
            }
            IWailaPlugin initializer = (IWailaPlugin)Class.forName(initializerStr).getConstructor(new Class[0]).newInstance(new Object[0]);
            PLUGIN_ID_TO_PLUGIN_INFO.put(rl, new PluginInfo(ModInfo.get(modId), rl, side, initializer, required, legacy, null, null));
            TOGGLE.get().putIfAbsent(rl, defaultEnabled);
        }
        catch (Throwable t) {
            LOG.error("Error creating instance of plugin " + pluginIdStr, t);
        }
    }

    public static PluginInfo get(class_2960 pluginId) {
        return PLUGIN_ID_TO_PLUGIN_INFO.get(pluginId);
    }

    public static Collection<PluginInfo> getAllFromMod(String modId) {
        return MOD_ID_TO_PLUGIN_INFOS.get().get(modId);
    }

    public static Collection<PluginInfo> getAll() {
        return PLUGIN_ID_TO_PLUGIN_INFO.values();
    }

    @Override
    public IModInfo getModInfo() {
        return this.modInfo;
    }

    @Override
    public class_2960 getPluginId() {
        return this.pluginId;
    }

    @Override
    public IPluginInfo.Side getSide() {
        return this.side.toDeprecated();
    }

    @Override
    public IWailaPlugin getInitializer() {
        if (this.deprecatedInit == null) {
            return EMPTY_INIT;
        }
        return this.deprecatedInit;
    }

    @Nullable
    public IWailaPlugin getDeprecatedInit() {
        return this.deprecatedInit;
    }

    @Nullable
    public IWailaCommonPlugin getCommon() {
        if (this.common == null) {
            return null;
        }
        return this.common.get();
    }

    @Nullable
    public IWailaClientPlugin getClient() {
        if (this.client == null) {
            return null;
        }
        if (!Waila.CLIENT_SIDE) {
            return null;
        }
        return this.client.get();
    }

    @Override
    public List<String> getRequiredModIds() {
        return this.requiredModIds;
    }

    @Override
    public boolean isEnabled() {
        if (this.disabledOnServer) {
            return false;
        }
        return this.isLocked() || TOGGLE.get().get(this.getPluginId()) != false;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public boolean isLocked() {
        return this.pluginId.equals((Object)CORE);
    }

    public boolean isDisabledOnServer() {
        return this.disabledOnServer;
    }

    public void setDisabledOnServer(boolean disabledOnServer) {
        this.disabledOnServer = disabledOnServer;
    }

    public void setEnabled(boolean enabled) {
        TOGGLE.get().put(this.getPluginId(), enabled);
    }

    public static void refresh() {
        TOGGLE.invalidate();
        PluginInfo.getAll().forEach(it -> {
            it.disabledOnServer = false;
        });
    }

    public static void saveToggleConfig() {
        TOGGLE.save();
    }
}

