/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.netty.buffer.Unpooled;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lol.bai.badpackets.api.PacketSender;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IWailaClientPlugin;
import mcp.mobius.waila.api.IWailaCommonPlugin;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.__internal__.Internals;
import mcp.mobius.waila.config.JsonConfig;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.mcless.version.VersionRanges;
import mcp.mobius.waila.network.Packets;
import mcp.mobius.waila.plugin.PluginInfo;
import mcp.mobius.waila.plugin.PluginSide;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.service.ICommonService;
import mcp.mobius.waila.util.Log;
import mcp.mobius.waila.util.ModInfo;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public abstract class PluginLoader {
    public static final PluginLoader INSTANCE = Internals.loadService(PluginLoader.class);
    private static final Log LOG = Log.create();
    protected static final String[] PLUGIN_JSON_FILES = new String[]{"waila_plugins.json", "wthit_plugins.json"};
    protected static final String KEY_ENTRYPOINTS = "entrypoints";
    protected static final String KEY_ENTRYPOINT_COMMON = "common";
    protected static final String KEY_ENTRYPOINT_CLIENT = "client";
    protected static final String KEY_INITIALIZER = "initializer";
    protected static final String KEY_SIDE = "side";
    protected static final String KEY_REQUIRED = "required";
    protected static final String KEY_DEFAULT_ENABLED = "defaultEnabled";
    protected static final Map<String, PluginSide> SIDES = Map.of("client", PluginSide.CLIENT, "server", PluginSide.DEDICATED_SERVER, "both", PluginSide.COMMON, "*", PluginSide.COMMON);
    private boolean gathered = false;
    public volatile boolean initialized = false;

    public static void reloadServerPlugins(MinecraftServer server) {
        PluginInfo.saveToggleConfig();
        PluginInfo.refresh();
        INSTANCE.loadPlugins();
        server.method_3760().method_14571().forEach(player -> {
            PacketSender sender = PacketSender.s2c((class_3222)player);
            if (!sender.canSend(Packets.PLUGIN)) {
                return;
            }
            if (!server.method_19466(player.method_7334())) {
                class_2540 buf = new class_2540(Unpooled.buffer());
                buf.method_34062(PluginInfo.getAll().stream().filter(it -> !it.isEnabled()).map(PluginInfo::getPluginId).toList(), class_2540::method_10812);
                sender.send(Packets.PLUGIN, buf);
            }
            Packets.sendConfig(sender);
        });
    }

    public static void reloadClientPlugins() {
        INSTANCE.loadPlugins();
        if (class_310.method_1551().method_1562() != null && PacketSender.c2s().canSend(Packets.CONFIG_SYNC_REQ)) {
            PacketSender.c2s().send(Packets.CONFIG_SYNC_REQ, new class_2540(Unpooled.buffer()));
        }
    }

    protected abstract void gatherPlugins();

    protected void readPluginsJson(String modId, Path path) {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonObject object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            block7: for (String pluginId : object.keySet()) {
                boolean defaultEnabled;
                PluginSide side;
                JsonObject plugin = object.getAsJsonObject(pluginId);
                String deprecatedInit = plugin.has(KEY_INITIALIZER) ? plugin.getAsJsonPrimitive(KEY_INITIALIZER).getAsString() : null;
                JsonObject entrypoints = plugin.has(KEY_ENTRYPOINTS) ? plugin.getAsJsonObject(KEY_ENTRYPOINTS) : null;
                PluginSide pluginSide = side = plugin.has(KEY_SIDE) ? Objects.requireNonNull(SIDES.get(plugin.get(KEY_SIDE).getAsString()), () -> PluginLoader.readError(path) + ", invalid side, available: " + SIDES.keySet().stream().collect(Collectors.joining(", ", "[", "]"))) : PluginSide.COMMON;
                if (!side.matches(ICommonService.INSTANCE.getSide())) continue;
                ArrayList<String> required = new ArrayList<String>();
                if (plugin.has(KEY_REQUIRED)) {
                    JsonElement requiredElement = plugin.get(KEY_REQUIRED);
                    if (requiredElement.isJsonArray()) {
                        JsonArray array = requiredElement.getAsJsonArray();
                        for (JsonElement element : array) {
                            String requiredModId = element.getAsString();
                            if (!ModInfo.get(requiredModId).isPresent()) continue block7;
                            required.add(requiredModId);
                        }
                    } else if (requiredElement.isJsonObject()) {
                        JsonObject requiredObj = requiredElement.getAsJsonObject();
                        for (String requiredModId : requiredObj.keySet()) {
                            ModInfo requiredMod = ModInfo.get(requiredModId);
                            String versionSpec = requiredObj.getAsJsonPrimitive(requiredModId).getAsString();
                            if (!requiredMod.isPresent() || !VersionRanges.parse(versionSpec).match(requiredMod.getVersion())) continue block7;
                            required.add(requiredModId);
                        }
                    }
                }
                boolean bl = defaultEnabled = !plugin.has(KEY_DEFAULT_ENABLED) || plugin.get(KEY_DEFAULT_ENABLED).getAsBoolean();
                if (deprecatedInit != null) {
                    PluginInfo.registerDeprecated(modId, pluginId, side, deprecatedInit, required, defaultEnabled, false);
                    continue;
                }
                if (entrypoints != null) {
                    String client;
                    String common = entrypoints.has(KEY_ENTRYPOINT_COMMON) ? entrypoints.getAsJsonPrimitive(KEY_ENTRYPOINT_COMMON).getAsString() : null;
                    String string = client = entrypoints.has(KEY_ENTRYPOINT_CLIENT) ? entrypoints.getAsJsonPrimitive(KEY_ENTRYPOINT_CLIENT).getAsString() : null;
                    if (common == null && client == null) {
                        throw new NullPointerException(PluginLoader.readError(path) + ", need at least one entrypoint");
                    }
                    PluginInfo.register(modId, pluginId, side, common, client, required, defaultEnabled);
                    continue;
                }
                throw new NullPointerException(PluginLoader.readError(path) + ", need at least one entrypoint");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(PluginLoader.readError(path), e);
        }
    }

    public final void loadPlugins() {
        Registrar.destroy();
        if (!this.gathered) {
            this.gathered = true;
            this.gatherPlugins();
            if (Waila.DEBUG_CONFIG.get().showTestPluginToggle) {
                PluginInfo.registerDeprecated("wthit", Waila.id("test").toString(), PluginSide.COMMON, "mcp.mobius.waila.plugin.test.WailaPluginTest", List.of(), false, false);
            }
        }
        PluginInfo.saveToggleConfig();
        PluginInfo extraPlugin = null;
        ArrayList<String> legacyPlugins = new ArrayList<String>();
        for (PluginInfo info : PluginInfo.getAll()) {
            if (info.getPluginId().equals((Object)Waila.id("extra"))) {
                extraPlugin = info;
            } else {
                this.initialize(info);
            }
            if (!info.isLegacy()) continue;
            legacyPlugins.add(info.getPluginId().toString());
        }
        if (extraPlugin != null) {
            this.initialize(extraPlugin);
        }
        if (!legacyPlugins.isEmpty()) {
            LOG.warn("Found plugins registered via legacy platform-dependant method:");
            LOG.warn(legacyPlugins.stream().collect(Collectors.joining(", ", "[", "]")));
            LOG.warn("The method will be removed on Minecraft 1.21");
        }
        Registrar.get().lock();
        PluginConfig.reload();
        JsonConfig.reloadAllInstances();
        this.initialized = true;
    }

    private void initialize(PluginInfo info) {
        Registrar.get().attach(info);
        class_2960 id = info.getPluginId();
        IWailaPlugin deprecatedInit = info.getDeprecatedInit();
        IWailaCommonPlugin common = info.getCommon();
        IWailaClientPlugin client = info.getClient();
        if (info.isEnabled()) {
            if (deprecatedInit != null) {
                LOG.info("Initializing plugin {} at {}", id, deprecatedInit.getClass().getCanonicalName());
            }
            if (common != null) {
                LOG.info("Initializing common plugin {} at {}", id, common.getClass().getCanonicalName());
            }
            if (client != null) {
                LOG.info("Initializing client plugin {} at {}", id, client.getClass().getCanonicalName());
            }
        } else {
            LOG.info("Skipping disabled plugin {}", id);
        }
        if (deprecatedInit != null) {
            deprecatedInit.register(Registrar.get());
        }
        if (common != null) {
            common.register(Registrar.get());
        }
        if (client != null) {
            client.register(Registrar.get());
        }
        Registrar.get().attach(null);
    }

    private static String readError(Path path) {
        return "Failed to read [" + path + "]";
    }
}

