/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.plugin.vanilla.config.EnchantmentDisplayMode;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1843;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_3544;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public enum ItemEntityProvider implements IEntityComponentProvider
{
    INSTANCE;

    private static long lastEnchantmentTime;
    private static int enchantmentIndex;
    private static int curseIndex;

    @Override
    @Nullable
    public class_1297 getOverride(IEntityAccessor accessor, IPluginConfig config) {
        return !config.getBoolean(Options.ENTITY_ITEM_ENTITY) ? EMPTY_ENTITY : null;
    }

    @Override
    public ITooltipComponent getIcon(IEntityAccessor accessor, IPluginConfig config) {
        return new ItemComponent(((class_1542)accessor.getEntity()).method_6983());
    }

    @Override
    public void appendHead(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        IWailaConfig.Formatter formatter = IWailaConfig.get().getFormatter();
        class_1799 stack = ((class_1542)accessor.getEntity()).method_6983();
        tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, formatter.entityName(stack.method_7964().getString()));
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY)) {
            tooltip.setLine(WailaConstants.REGISTRY_NAME_TAG, formatter.registryName(class_7923.field_41178.method_10221((Object)stack.method_7909())));
        }
    }

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        class_1799 stack = ((class_1542)accessor.getEntity()).method_6983();
        ItemEntityProvider.appendBookProperties(tooltip, stack, config);
    }

    @Override
    public void appendTail(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            String mod = IModInfo.get(((class_1542)accessor.getEntity()).method_6983()).getName();
            tooltip.setLine(WailaConstants.MOD_NAME_TAG, IWailaConfig.get().getFormatter().modName(mod));
        }
    }

    public static void appendBookProperties(ITooltip tooltip, class_1799 stack, IPluginConfig config) {
        if (stack.method_31574(class_1802.field_8598)) {
            EnchantmentDisplayMode mode = (EnchantmentDisplayMode)((Object)config.getEnum(Options.BOOK_ENCHANTMENT_DISPLAY_MODE));
            if (mode == EnchantmentDisplayMode.DISABLED) {
                return;
            }
            if (mode == EnchantmentDisplayMode.CYCLE) {
                int enchantmentTiming = config.getInt(Options.BOOK_ENCHANTMENT_CYCLE_TIMING);
                class_2499 enchantmentsTag = class_1772.method_7806((class_1799)stack);
                long now = System.currentTimeMillis();
                ArrayList<class_1889> enchantments = new ArrayList<class_1889>();
                ArrayList<class_1889> curses = new ArrayList<class_1889>();
                for (int i = 0; i < enchantmentsTag.size(); ++i) {
                    class_2487 enchantmentTag = enchantmentsTag.method_10602(i);
                    class_1887 enchantment2 = (class_1887)class_7923.field_41176.method_10223(class_1890.method_37427((class_2487)enchantmentTag));
                    if (enchantment2 == null) continue;
                    int level2 = class_1890.method_37424((class_2487)enchantmentTag);
                    class_1889 instance = new class_1889(enchantment2, level2);
                    if (enchantment2.method_8195()) {
                        curses.add(instance);
                        continue;
                    }
                    enchantments.add(instance);
                }
                if (now - lastEnchantmentTime >= (long)enchantmentTiming) {
                    lastEnchantmentTime = now;
                    ++curseIndex;
                    if (++enchantmentIndex > enchantments.size() - 1) {
                        enchantmentIndex = 0;
                    }
                    if (curseIndex > curses.size() - 1) {
                        curseIndex = 0;
                    }
                }
                if (!enchantments.isEmpty()) {
                    class_1889 instance = (class_1889)enchantments.get(enchantmentIndex);
                    tooltip.addLine(instance.field_9093.method_8179(instance.field_9094));
                }
                if (!curses.isEmpty()) {
                    class_1889 instance = (class_1889)curses.get(curseIndex);
                    tooltip.addLine(instance.field_9093.method_8179(instance.field_9094));
                }
            } else {
                Map enchantments = class_1890.method_8222((class_1799)stack);
                if (mode == EnchantmentDisplayMode.COMBINED) {
                    class_5250 enchantmentLine = null;
                    class_5250 curseLine = null;
                    for (Map.Entry entry : enchantments.entrySet()) {
                        class_1887 enchantment3 = (class_1887)entry.getKey();
                        int level3 = (Integer)entry.getValue();
                        class_2561 name = enchantment3.method_8179(level3);
                        if (enchantment3.method_8195()) {
                            if (curseLine == null) {
                                curseLine = class_2561.method_43473().method_10852(name);
                                continue;
                            }
                            curseLine.method_10852((class_2561)class_2561.method_43470((String)", ")).method_10852(name);
                            continue;
                        }
                        if (enchantmentLine == null) {
                            enchantmentLine = class_2561.method_43473().method_10852(name);
                            continue;
                        }
                        enchantmentLine.method_10852((class_2561)class_2561.method_43470((String)", ")).method_10852(name);
                    }
                    if (enchantmentLine != null) {
                        tooltip.addLine((class_2561)enchantmentLine);
                    }
                    if (curseLine != null) {
                        tooltip.addLine((class_2561)curseLine);
                    }
                } else {
                    enchantments.forEach((enchantment, level) -> tooltip.addLine(enchantment.method_8179(level.intValue())));
                }
            }
        } else if (stack.method_31574(class_1802.field_8360)) {
            if (!config.getBoolean(Options.BOOK_WRITTEN) || !stack.method_7985()) {
                return;
            }
            class_2487 tag = Objects.requireNonNull(stack.method_7969());
            String author = tag.method_10558("author");
            int generation = class_1843.method_8052((class_1799)stack);
            if (!class_3544.method_15438((String)author)) {
                tooltip.addLine((class_2561)class_2561.method_43469((String)"book.byAuthor", (Object[])new Object[]{author}));
            }
            tooltip.addLine((class_2561)class_2561.method_43471((String)("book.generation." + generation)));
        }
    }

    static {
        lastEnchantmentTime = 0L;
        enchantmentIndex = 0;
        curseIndex = 0;
    }
}

